IF EXISTS ( SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_ORCAMENTO]') ) 
	DROP VIEW [dbo].[V_ORCAMENTO]; 
GO 
CREATE VIEW [dbo].[V_ORCAMENTO] AS 
SELECT 
	ORC.CD_EMP, 
	ORC.CD_FILIAL, 
	ORC.CD_ORC, 
	ORC.DT_EMI, 
	ORC.HR_EMI, 
	ORC.NR_PED_TELEVD AS NR_PEDIDO, 
	CASE WHEN COALESCE(ORC.CD_CONV, 0) != 0 THEN 
		1 
	ELSE 
		NULL 
	END AS CONTEM_CONVENIO, 
	CASE WHEN COALESCE(ORC.TIPO_PBM, -1) != -1 THEN 
		1 
	ELSE 
		NULL 
	END AS CONTEM_PBM, 
	CASE WHEN ORC.TP_ORC_ENTG = 1 THEN 
		1 
	ELSE 
		NULL 
	END AS CONTEM_ENTREGA, 
	CASE WHEN RECEITA.NR_ORC IS NOT NULL THEN 
		1 
	ELSE 
		NULL 
	END AS CONTEM_RECEITA, 
	COALESCE(RECEITA.CD_MEDICO_REC, 0) AS MEDICO_ID, 
	MEDICO.NM_MEDICO AS MEDICO_NM, 
	MEDICO.CD_TP_DOC AS MEDICO_TP_DOC, 
	MEDICO.NR_DOC AS MEDICO_NR_DOC, 
	MEDICO.UF_DOC AS MEDICO_UF_DOC, 
	COALESCE(RECEITA.NR_RECEITA, 0) AS NUMERO_RECEITA, 
	COALESCE(RECEITA.CD_RECEITA, 0) AS CODIGO_RECEITA, 
	RECEITA.DT_RECEITA, RECEITA.TP_CAPT_RECEITA AS TIPO_CAPTACAO_RECEITA, 
	CLI.CD_CLI, 
	COALESCE(CLI.RZ_CLI, ORC.NM_COMPRADOR) AS NM_CLI, 
	CLI.CGC_CPF AS CLI_CGCCPF, 
	ORC.NR_CARTAO_FIDELIDADE AS NR_CARTAO_CLI, 
	ORC.FONE_CLI, 
	0 AS TP_ORC, 
	ORC.TIPO_PRAZO_PGTO AS TP_PRAZO_PGTO, 
	ORC.CD_FRM_PGTO AS CD_FORMA_PGTO, 
	ORC.ORIG_ORC AS ORIGEM_ORC, 
	ORC.VD_TROCA_FIDEL, 
	ORC.STS_ORC, 
	ORC.OBS, 
	ORC.DADOS_ADICIONAIS, 
	0 AS OFFLINE, 
	CPL.CD_PROD, 
	PROD.DS_PROD, 
	CPL.QT AS QT_IT, 
	CPL.VLR_IT, 
	CPL.VLR_TOT_IT, 
	CPL.VLR_DESC, 
	CPL.PERC_DESC, 
	CPL.CD_VEND, 
	VEND.NM_FUN AS NM_VEND, 
	ORC.CD_VEND_LIB AS VEND_LIB, 
	VEND_LIB.NM_FUN AS VEND_LIB_NM, 
	CPL.PR_TAB AS VLR_IT_TAB, 
	CPL.OFERTA AS IS_OFERTA_IT, 
	CPL.PERC_DESC_CAD, 
	CPL.PERC_DESC_FIX, 
	CPL.VLR_DESC_FIX, 
	CPL.TIPO_DESCONTO AS TP_DESC, 
	CPL.QTDE_PONTO_FIDEL AS QT_PONTOS_FIDEL, 
	CPL.VLR_ECONOMIA, 
	CPL.VLR_DESC_VERBA, 
	CPL.PERC_DESC_VERBA, 
	CPL.CD_VEND_VERBA, 
	VEND_VERBA.NM_FUN AS NM_VEND_VERBA, 
	CPL.LIBERA_VD_CONV, 
	CPL.VLR_CUSTO_SEMAFORO, 
	0 AS QT_EST, 
	CPL.CD_GRP AS CD_GRUPO_COMISSAO, 
	CPL.NR_PROTOCOLO_MANIPULADO, 
	0 AS PERC_DESCONTO_POS_PBM, 
	DESCONTO_CONCORRENTE.CD_CONCOR AS CD_CONCORRENTE, 
	DESCONTO_CONCORRENTE.VLR_CONCOR AS VLR_CONCORRENTE, 
	MED_ESP.SIGLA AS SIGLA 
FROM 
	EST_ORC AS ORC JOIN EST_ORC_CPL AS CPL ON 
	ORC.CD_EMP = CPL.CD_EMP AND 
	ORC.CD_FILIAL = CPL.CD_FILIAL AND 
	ORC.CD_ORC = CPL.CD_ORC 
	LEFT JOIN RC_CLI AS CLI ON 
	ORC.CD_EMP = CLI.CD_EMP AND 
	ORC.CD_CLI = CLI.CD_CLI 
	LEFT JOIN EST_ORC_GLB_MEDICO AS RECEITA ON 
	CPL.CD_EMP = RECEITA.CD_EMP AND 
	CPL.CD_FILIAL = RECEITA.CD_FILIAL AND 
	CPL.CD_ORC = RECEITA.NR_ORC AND 
	CPL.CD_PROD = RECEITA.CD_PROD 
	LEFT JOIN GLB_MEDICOS AS MEDICO ON 
	CPL.CD_EMP = MEDICO.CD_EMP AND 
	RECEITA.CD_MEDICO_REC = MEDICO.CD_CTR 
	INNER JOIN GLB_ESPECIALIDADES AS MED_ESP ON 
	MED_ESP.CD_ESPECIALIDADE = MEDICO.CD_ESPECIALIDADE 
	LEFT JOIN FP_FUNC AS VEND_LIB ON 
	ORC.CD_EMP = VEND_LIB.CD_EMP AND 
	ORC.CD_VEND_LIB = VEND_LIB.CD_FUN 
	LEFT JOIN EST_PROD AS PROD ON 
	CPL.CD_EMP = PROD.CD_EMP AND 
	CPL.CD_PROD = PROD.CD_PROD 
	LEFT JOIN FP_FUNC AS VEND ON 
	CPL.CD_EMP = VEND.CD_EMP AND 
	CPL.CD_VEND = VEND.CD_FUN 
	LEFT JOIN FP_FUNC AS VEND_VERBA ON 
	CPL.CD_EMP = VEND_VERBA.CD_EMP AND 
	CPL.CD_VEND_VERBA = VEND_VERBA.CD_FUN 
	LEFT JOIN EST_ORC_CPL_CONCOR AS DESCONTO_CONCORRENTE ON 
	CPL.CD_EMP = DESCONTO_CONCORRENTE.CD_EMP AND 
	CPL.CD_FILIAL = DESCONTO_CONCORRENTE.CD_FILIAL AND 
	CPL.CD_ORC = DESCONTO_CONCORRENTE.NR_ORC AND 
	CPL.CD_PROD = DESCONTO_CONCORRENTE.CD_PROD AND 
	CPL.CD_IT = DESCONTO_CONCORRENTE.CD_IT;